/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system.launchers.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.applications.JavaUtils;
import org.netbeans.installer.utils.helper.JavaCompatibleProperties;
import org.netbeans.installer.utils.progress.Progress;
import org.netbeans.installer.utils.system.launchers.LauncherProperties;
import org.netbeans.installer.utils.system.launchers.LauncherResource;
import org.netbeans.installer.utils.system.launchers.impl.CommonLauncher;

public class JarLauncher
extends CommonLauncher {
    public static final String MIN_JAVA_VERSION_DEFAULT = "1.5";

    public JarLauncher(LauncherProperties props) {
        super(props);
    }

    @Override
    public void initialize() throws IOException {
        this.checkBundledJars();
        this.checkOutputFileName();
        this.checkCompatibleJava();
    }

    @Override
    public File create(Progress progress) throws IOException {
        File jarFile;
        LogManager.log("Create Jar launcher... ");
        File out = null;
        for (LauncherResource file : this.jars) {
            if (!file.isBundled()) continue;
            jarFile = new File(file.getPath());
            if (jarFile.getCanonicalPath().equals(this.outputFile.getCanonicalPath())) {
                out = jarFile;
                break;
            }
            out = this.outputFile;
            FileUtils.copyFile(jarFile, out);
            break;
        }
        if (out != null) {
            for (LauncherResource file : this.jars) {
                if (file.isBundled()) continue;
                jarFile = new File(file.getPath());
                if (jarFile.getCanonicalPath().equals(this.outputFile.getCanonicalPath())) {
                    out = jarFile;
                    break;
                }
                out = this.outputFile;
                break;
            }
        }
        return out;
    }

    @Override
    public String getExtension() {
        return ".jar";
    }

    @Override
    public String getI18NResourcePrefix() {
        return null;
    }

    @Override
    public String getI18NBundleBaseName() {
        return null;
    }

    @Override
    public String[] getExecutionCommand() {
        File javaLocation = null;
        for (LauncherResource java : this.jvms) {
            switch (java.getPathType()) {
                case ABSOLUTE: {
                    javaLocation = new File(java.getPath());
                    break;
                }
                case RELATIVE_USERHOME: {
                    javaLocation = new File(SystemUtils.getUserHomeDirectory(), java.getPath());
                    break;
                }
                case RELATIVE_LAUNCHER_PARENT: {
                    javaLocation = new File(this.outputFile.getParentFile(), java.getPath());
                    break;
                }
            }
            if (javaLocation == null) continue;
            for (JavaCompatibleProperties javaCompat : this.compatibleJava) {
            }
        }
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(JavaUtils.getExecutableW(javaLocation).getAbsolutePath());
        commandList.add("-cp");
        String classpath = "";
        for (LauncherResource jar : this.jars) {
            switch (jar.getPathType()) {
                case RELATIVE_JAVAHOME: {
                    classpath = classpath + new File(javaLocation, jar.getPath()) + SystemUtils.getPathSeparator();
                    break;
                }
                case ABSOLUTE: {
                    classpath = classpath + new File(jar.getPath()) + SystemUtils.getPathSeparator();
                    break;
                }
                case RELATIVE_USERHOME: {
                    classpath = classpath + new File(SystemUtils.getUserHomeDirectory(), jar.getPath()) + SystemUtils.getPathSeparator();
                    break;
                }
                case RELATIVE_LAUNCHER_PARENT: {
                    classpath = classpath + new File(this.outputFile.getParentFile(), jar.getPath()) + SystemUtils.getPathSeparator();
                    break;
                }
            }
        }
        commandList.add(classpath);
        commandList.addAll(this.jvmArguments);
        commandList.add(this.mainClass);
        commandList.addAll(this.appArguments);
        return commandList.toArray(new String[commandList.size()]);
    }

    public List<JavaCompatibleProperties> getDefaultCompatibleJava() {
        ArrayList<JavaCompatibleProperties> list = new ArrayList<JavaCompatibleProperties>();
        list.add(new JavaCompatibleProperties(MIN_JAVA_VERSION_DEFAULT, null, null, null, null));
        return list;
    }
}

